<div class="card">
    <form 
        class="_form" method="post"
        action="{{url('ventures/_wallet')}}">
        <input type="hidden" name="user_id" value="{{$item->id}}" />
        <div class="card-body">
            <div class="row">
                <x-form.input div="col-md-8" label="Modal Disetor" name="setor" placeholder="Masukan Modal Disetor" class="inputRupiah" />
                <x-form.input div="col-md-4" type="number" label="Biaya Modal %" name="modal" placeholder="Masukan Biaya Modal %" min="0" max="100">
                    <x-slot name="note">
                        *Beban pengguna
                    </x-slot>
                </x-form.input>
                <div class="form-group col-md-4">
                    <label for="resultCalculate">Periode</label>
                    <input class="form-control" name="periode" value="{{bulan(date('Y-m-d'))}}" readonly />
                </div>
                <div class="form-group col-md-8">
                    <label for="resultCalculate">Hasil</label>
                    <input class="form-control" placeholder="Hasil perhitungan = (Modal Disetor * Biaya Modal %)" id="resultCalculate" readonly />
                </div>
            </div>
            <div class="form-group">
                <label for="file">Bukti Transfer</label>
                <br />
                <input 
                    type="file" name="file" 
                    id="file" accept=".jpg, .png" required />
            </div>
        </div>
        <div class="card-footer">
            <a 
                onclick="return history.go(-1)" 
                class="btn btn-default" 
                id="_backButton">Kembali</a>
            <button type="submit" class="btn btn-primary">Simpan</button>
        </div>
    </form>
</div>

@push('js')
    <script type="text/javascript" src="{{_asset('js/rupiah.js')}}"></script>
    <script>
        const $setor = $(`input[name="setor"]`)
        const $modal = $(`input[name="modal"]`)

        var do_getCalculate;

        $(document).ready(function() {
            $setor.on('input', (e) => {
                getCalculate()
            });

            $modal.on('input', (e) => {
                getCalculate()
            });
        });
        
        const getCalculate = () => {
            clearTimeout(do_getCalculate);

            $(`#resultCalculate`).val('')

            do_getCalculate = setTimeout(() => {
                var valSetor = Number($setor.val().replace(/[^,\d]/g, ""))
                var valModal = $modal.val() / 100

                if (valModal && valSetor) {
                    var total = valSetor * valModal
                    var resultConvert = new Intl.NumberFormat('id-ID', {
                        currency: 'IDR',
                    }).format(total)

                    $(`#resultCalculate`).val(`Rp ${resultConvert}`)
                }
            }, 500);
        };
    </script>
@endpush