<x-layout title="{{$title}}">

  <x-breadcrumb
    title="{{$title}}"
    :items="[
      [$title]
    ]" />

  <section class="content px-3">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">{{$title}}</h3>
      </div>
      <form 
        class="_form" 
        action="{{url('configuration/store')}}" 
        method="post" 
        enctype="multipart/form-data">
        <div class="card-body row">

          <x-form.input 
            div="col-md-12" 
            label="Judul Website" placeholder="Masukan judul website" 
            name="title" value="{{$item->title}}" />

          <div class="form-group col-md-12">
            <label>Meta Kata Kunci</label>
            <textarea name="meta_keyword" class="form-control" rows="3" placeholder="Kata kunci pencarian">{{$item->meta_keyword}}</textarea>
          </div>

          <div class="form-group col-md-12">
            <label>Meta Deskripsi</label>
            <textarea name="meta_description" class="form-control" rows="3" placeholder="Deskripsi singkat">{{$item->meta_description}}</textarea>
          </div>

          <div class="form-group col-md-12">
            <label>Deskripsi</label>
            <textarea name="description" class="form-control editor" data-placeholder="Masukan deskripsi">{{$item->description}}</textarea>
          </div>

          <div class="form-group col-md-6">
            <label for="file">Ikon Web</label>
            <br />
            <input 
              type="file" name="web_icon" 
              id="file" 
              accept=".jpg, .png" />
            <div id="preview">
              <img 
                src="{{base_url($item->web_icon)}}" 
                id="preview" 
                style="margin-top: 10px; width:200px; height:auto;">
            </div>
          </div>

          <div class="form-group col-md-6">
            <label for="file">Ikon Merek</label>
            <br />
            <input 
              type="file" name="mark_icon" 
              id="file2" 
              accept=".jpg, .png" />
            <div id="preview">
              <img 
                src="{{base_url($item->mark_icon)}}" 
                id="preview2" 
                style="margin-top: 10px; width:200px; height:auto;">
            </div>
          </div>

          <x-form.input 
            div="col-md-6" 
            label="Email OTP" placeholder="Masukan email otp" 
            name="email_getotp" value="{{$item->email_getotp}}" />

          <div class="form-group col-md-12 mt-3">
            <h4 class="text-bold">Rekening Tarik Dana</h4>
          </div>
          <x-form.input 
            div="col-md-6" 
            label="Pemilik Rekening" placeholder="Masukan nama pemilik" 
            name="account_name" value="{{$item->account_name}}" />
          <x-form.input 
            div="col-md-6" 
            label="Nomor Rekening" placeholder="Masukan nomor rekening" 
            name="account_number" value="{{$item->account_number}}" />
          <x-form.select 
            div="col-md-6" 
            label="Bank" name="account_bank" value="{{$item->account_bank}}"
            :collection="$banks" :option="['id', ['title']]" />

        </div>
        <div class="card-footer">
          <button 
            type="submit" 
            class="btn btn-primary" 
            id="_button">Simpan</button>
        </div>
      </form>
    </div>
  </section>

  <x-slot name="js">
    <script type="text/javascript" src="{{_asset('plugins/ckeditor/super-build.js')}}"></script>
    <script type="text/javascript" src="{{_asset('plugins/ckeditor/es.js')}}"></script>
    <script type="text/javascript" src="{{_asset('js/ckeditor5.super.js')}}"></script>
    
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
  </x-slot>
</x-layout>