<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="row">

      <x-search.opex.pengeluaran class="col-md-12 mb-3" />

      <x-partial.tab-role href="opex/pengeluaran">
        <thead>
          <tr>
            <th class="w-10px">No</th>
            <th>ID</th>
            <th>Tanggal</th>
            <th>Dibuat Oleh</th>
            <th>Grand Total</th>
            <th class="w-100px">Aksi</th>
          </tr>
        </thead>
        <tbody>
          @foreach ($collection as $key => $item)
            <tr id="data-{{$item->id}}">
              <td class="numbering">{{no($key)}}</td>
              <td>{{$item->id}}</td>
              <td>{{$item->purchase_dated}}</td>
              <td>{{$item->user?->name ?? '-'}}</td>
              <td>Rp {{number_format($item->items_sum_subtotal)}}</td>
              <td id="action-{{$item->id}}">
                <a 
                  href="{{url('opex/pengeluaran/find/'.$item->id)}}" 
                  class="btn btn-warning btn-sm">
                  <i class="fas fa-link mr-2"></i>
                  Detail
                </a>
              </td>
            </tr>
          @endforeach
        </tbody>

        <x-slot name="extra">
          {{$collection->links('vendor.pagination.bootstrap-5')}}
        </x-slot>
      </x-partial.tab-role>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/date-input.js')}}"></script>
  </x-slot>

</x-layout>