<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}" 
    :items="[
      [$title, url('payment-method')],
      ['Edit']
    ]" />

  <section class="content px-3">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">Edit {{$title}}</h3>
      </div>
      <form 
        class="_form" 
        action="{{url('payment-method/_update')}}" 
        method="post" 
        enctype="multipart/form-data">
        <div class="card-body">
          <input type="hidden" name="id" value="{{$item->id}}" />
          <div class="row">
            <x-form.input 
              label="Nama" name="title" div="col-md-6"
              placeholder="Masukan nama" value="{{$item->title}}" />
            <x-form.input 
              label="Kode" div="col-md-6" value="{{$item->code}}" readonly />
            <x-form.select 
              label="Tipe Tax" name="tax_type" div="col-md-6"
              value="{{$item->tax_type}}" :option="['id', ['text']]"
              :collection="[
                ['id' => 'nominal', 'text' => 'Nominal'],
                ['id' => 'percent', 'text' => 'Persen']
              ]" />
            <x-form.input 
              label="Tax" name="tax" div="col-md-6"
              placeholder="Masukan tax" value="{{$item->tax}}" />
          </div>
          <div class="form-group">
            <label>Langkah-Langkah</label>
            <textarea name="steps" class="form-control editor" data-placeholder="Masukan langkah-langkah">{{$item->steps}}</textarea>
          </div>
          <div class="form-group">
            <label for="file">Gambar {{$title}}</label>
            <br />
            <input 
              type="file" name="file" id="file" 
              accept=".jpg, .png" />
            <div id="preview">
              <img 
                src="{{base_url($item->file)}}" 
                id="preview" 
                style="margin-top: 10px; width:200px; height:auto;">
            </div>
          </div>
        </div>
        <div class="card-footer">
          <a 
            onclick="return history.go(-1)" 
            class="btn btn-default" 
            id="_backButton">Kembali</a>
          <button 
            type="submit" 
            class="btn btn-primary" 
            id="_button">Simpan</button>
        </div>
      </form>
    </div>
  </section>

  <x-slot name="js">
    <script type="text/javascript" src="{{_asset('plugins/ckeditor/super-build.js')}}"></script>
    <script type="text/javascript" src="{{_asset('plugins/ckeditor/es.js')}}"></script>
    <script type="text/javascript" src="{{_asset('js/ckeditor5.super.js')}}"></script>
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
  </x-slot>
</x-layout>