<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="card card-primary card-tabs">
      <div class="card-header p-0 pt-1">
        <ul class="nav nav-tabs" id="custom-tabs-one-tab" role="tablist">
          @foreach ($types as $key => $type)
            <li class="nav-item">
              <a class="nav-link {{!empty($_GET['type']) && $_GET['type'] == $type->id ? 'active' : ''}} {{empty($_GET['type']) && $key === 0 ? 'active' : ''}}" href="{{url('payment-method?type='.$type->id)}}">
                {{$type->name}}
              </a>
            </li>
          @endforeach
        </ul>
      </div>
      <div class="card-body">
        <div class="tab-content">
          <div class="tab-pane fade show active">
            <div class="table-responsive mb-0">
              <table class="table table-bordered table-hover text-nowrap">
                <thead>
                  <tr>
                    <th class="w-10px">No</th>
                    <th>Nama</th>
                    <th>Tipe</th>
                    <th>Kode</th>
                    <th>Tipe Tax</th>
                    <th>Tax</th>
                    <th>Aksi</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($collection as $key => $item)
                    <tr id="data-{{$item->id}}">
                      <td class="numbering">{{no($key)}}</td>
                      <td>
                        <img 
                          src="{{base_url($item->file)}}" 
                          class="w-100px mr-2" 
                          alt="type pembayaran" />
                        
                        <span>{{$item->name}}</span>
                      </td>
                      <td>{{$item->type_as->name}}</td>
                      <td>{{$item->code}}</td>
                      <td>{{$item->tax_type}}</td>
                      <td>{{number_format($item->tax)}}</td>
                      <td id="action-{{$item->id}}">
                        @if ($item->deleted_at)
                          <form 
                          action="{{url('payment-method/_delete')}}" 
                          style="display:inline-block;" 
                          class="deleteForm-{{$item->id}}">
                            <button 
                              type="button" 
                              onclick="return confirmation('{{$item->id}}', '1')" 
                              class="btn btn-success btn-sm">
                              <i class="fa-solid fa-trash-can-arrow-up mr-2"></i>
                              Pulihkan
                            </button>
                          </form>
                        @else
                          <x-partial.button-edit href="payment-method/edit/{{$item->id}}" />
      
                          <x-partial.button-delete
                            action="payment-method/_delete"
                            id="{{$item->id}}" />
                        @endif
                      </td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/delete.js?ls=pulihkan')}}" 
      element="reload-withoutdescription"></script>
  </x-slot>

</x-layout>