<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title, url('po')],
      [$item->id]
    ]" /> 

  <section class="content px-3">
    <div class="card">
      <div class="card-body">
        <p class="text-bold mb-3">Kode Transaksi : <u>{{$item->id}}</u></p>

        <div class="row mb-2">
          <x-form.input 
            div="col-md-5" value="{{$item->user?->name ?? '-'}}"
            label="Dibuat Oleh" readonly />
          <x-form.input 
            div="col-md-2" value="{{$item->purchase_dated}}"
            label="Tanggal PO" readonly />
          <x-form.input 
            div="col-md-5" value="{{$item->customer?->name ?? '-'}}"
            label="Pelanggan" readonly />
        </div>

        <h4 class="text-bold">PEMBAYARAN</h4>

        <div class="row">
          <x-form.input 
            div="col-md-4" value="{{ucwords($item->transaction_type)}}"
            label="Jenis Transaksi" readonly />
          <x-form.input 
            div="col-md-4" value="{{ucwords($item->payment_method)}}"
            label="Tipe Pembayaran" readonly />
          @if ($item->transaction_type == 'tempo')
            <x-form.input 
              div="col-md-4" value="{{$item->due_dated}}"
              label="Jatuh Tempo" readonly />
          @endif
          @if ($item->payment_date)
            <x-form.input 
              div="col-md-4" value="{{$item->payment_dated}}"
              label="Tanggal Dibayar" readonly />
          @endif
        </div>
        
        <div class="d-flex mb-4">
          <div class="mr-2">
            <a href="{{base_url($item->upload_po)}}" class="btn btn-{{$item->upload_po ? 'success' : 'danger'}}">
              <i class="fas fa-{{$item->upload_po ? 'check' : 'times'}} mr-2"></i>      
              File Purchase Order
            </a>
          </div>
          <div class="mr-2">
            <a href="{{base_url($item->upload_receipt)}}" class="btn btn-{{$item->upload_receipt ? 'success' : 'danger'}}">
              <i class="fas fa-{{$item->upload_receipt ? 'check' : 'times'}} mr-2"></i>      
              Tanda Terima 
            </a>
          </div>
          <div class="mr-2">
            <a href="{{base_url($item->upload_handover)}}" class="btn btn-{{$item->upload_handover ? 'success' : 'danger'}}">
              <i class="fas fa-{{$item->upload_handover ? 'check' : 'times'}} mr-2"></i>      
              Serah Terima 
            </a>
          </div>
        </div>

        <h4 class="text-bold">PRODUK</h4>

        <div class="mb-2">
          @foreach ($item->items as $e)
            <div class="row" style="border-bottom:1px solid #e9ecef">
              <x-form.input 
                div="col-md-6" value="{{$e->product['title']}}"
                label="Nama Produk" readonly />
              <x-form.input 
                div="col-md-3" value="{{$e->product['unit']}}"
                label="Satuan Unit" readonly />
              <x-form.input 
                div="col-md-3" value="{{$e->product['package']}}"
                label="Kemasan" readonly />

              <x-form.input 
                div="col-md-4" value="{{$e->qty}}"
                label="Jumlah" readonly />
              <x-form.input 
                div="col-md-4" value="{{number_format($e->price)}}"
                label="Harga Satuan" readonly />
              <x-form.input 
                div="col-md-4" value="{{number_format($e->subtotal)}}"
                label="Subtotal" readonly />
              <x-form.input 
                div="col-md-12" value="{{$e->description}}"
                label="Keterangan" readonly />
            </div>
          @endforeach
        </div>

      </div>
      <div class="card-footer">
        <a 
          onclick="return history.go(-1)" 
          class="btn btn-default" 
          id="_backButton">Kembali</a>
      </div>
    </div>
  </section>

</x-layout>