<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}" 
    :items="[
      [$title, url('products')],
      ['Detail Produk']
    ]" />

  <section class="content px-3">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">Detail Produk</h3>
      </div>

        <div class="card-body">
          <p class="text-bold mt-3 mb-0">SKU : <span style="color:red;">{{$item->sku}}</span></p>
          <p class="text-bold mb-3">Dibuat Oleh : <u>{{$item->user->name}}</u></p>
  
          <x-form.input 
            label="Nama Produk" readonly
            value="{{$item->title}}" />
          <div class="row">
            <x-form.input 
              label="Kategori" readonly div="col-md-4"
              value="{{$item->category?->title ?? 'KATEGORI KOSONG'}}" />
            <x-form.input 
              label="Kemasan" readonly div="col-md-4"
              value="{{$item->package?->title ?? 'KEMASAN KOSONG'}}" />
            <x-form.input 
              label="Satuan" readonly div="col-md-4"
              value="{{$item->unit?->title ?? 'SATUAN KOSONG'}}" />
          </div>
        </div>
        <div class="card-footer">
          <a 
            onclick="return history.go(-1)" 
            class="btn btn-default" 
            id="_backButton">Kembali</a>
        </div>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
  </x-slot>
</x-layout>