<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="row">

      <x-search.product.list class="col-md-12 col-12 mb-3" />

      <div class="col-12 mb-3">
        <x-partial.table-content>
          <thead>
            <tr>
              <th class="w-10px">No</th>
              <th>Nama Produk</th>
              <th>SKU</th>
              <th>Kategori</th>
              <th>Kemasan</th>
              <th>Satuan</th>
              <th>Dibuat Oleh</th>
              <th class="w-100px">Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($collection as $key => $item)
              <tr id="data-{{$item->id}}">
                <td class="numbering">{{no($key)}}</td>
                <td>{{$item->title}}</td>
                <td>{{$item->sku}}</td>
                <td>{{$item->category?->title ?? '-'}}</td>
                <td>{{$item->package?->title ?? '-'}}</td>
                <td>{{$item->unit?->title ?? '-'}}</td>
                <td>{{$item->user?->name ?? '-'}}</td>
                <td id="action-{{$item->id}}">
                    <a 
                      href="{{url('products/find/'.$item->id)}}" 
                      class="btn btn-warning btn-sm">
                      <i class="fas fa-link mr-2"></i>
                      Detail
                    </a>
                </td>
              </tr>
            @endforeach
          </tbody>
        </x-partial.table-content>

        <div class="mt-2">
          {{$collection->links('vendor.pagination.bootstrap-5')}}
        </div>
      </div>
    </div>
  </section>

</x-layout>