<x-layout title="{{auth()->user()->name}}">
  <x-breadcrumb :items="[
    ['Profile']
  ]" title="Profile" /> 
  <section class="content px-3">

    <div class="card mb-5">
      <div class="card-header">
        <h3 class="card-title">Data Profile</h3>
      </div>
      <form 
        class="_form" 
        action="{{url('profile/_edit')}}" 
        method="post">
        <div class="card-body row">
          <x-form.input 
            div="col-md-6" 
            label="Nama" 
            name="name" 
            placeholder="Masukan nama" 
            value="{{auth()->user()->name}}" />
          <x-form.input 
            div="col-md-6" 
            label="Email" 
            type="email" name="email" 
            placeholder="Masukan email" 
            value="{{auth()->user()->email}}" />
        </div>
        <div class="card-footer">
          <button 
            type="submit" 
            class="btn btn-primary" 
            id="_button">Simpan</button>
        </div>
      </form>
    </div>

    <div class="card">
      <div class="card-header">
        <h3 class="card-title">Ubah Password</h3>
      </div>
      <form 
        class="_form" 
        action="{{url('profile/_password')}}" 
        method="post">
        <div class="card-body row">
          <x-form.input 
            div="col-md-4" 
            label="Password Sekarang" 
            type="password" name="curr_password" 
            placeholder="Password Sekarang" />
          <x-form.input 
            div="col-md-4" 
            label="Password Baru" 
            type="password" name="password" 
            placeholder="Password Baru" />
          <x-form.input 
            div="col-md-4" 
            label="Konfirmasi Password Baru" 
            type="password" name="password_confirmation" 
            placeholder="Konfirmasi Password Baru" />
        </div>
        <div class="card-footer">
          <button 
            type="submit" 
            class="btn btn-primary" 
            id="_button">Simpan</button>
        </div>
      </form>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
  </x-slot>
</x-layout>