<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="row">
      <x-partial.box 
        title="Total Pengambilan" value="Rp {{number_format($total)}}" 
        icon="fas fa-wallet" div="col-md-6" class="bg-info" />
    </div>
    
    <div class="card">
      <form action="{{url('revenue/store')}}" method="post" class="_form">
        <div class="card-body">
          <x-form.input 
            label="Keuntungan Ditarik" name="nominal" 
            placeholder="Masukan Keuntungan Ditarik" />
          <div class="row">
            <x-form.input 
              div="col-md-6" readonly
              label="Ditarik Oleh" value="{{auth()->user()->name}}" />
            <x-form.input 
              div="col-md-6" name="date" max="{{date('Y-m-d')}}"
              label="Tanggal Ditarik" type="date" />
          </div>
          <x-form.image 
            label="Bukti Transfer" name="profile"
            id="file" required="off" />
        </div>
        <div class="card-footer">
          <button type="submit" class="btn btn-primary">Tarik</button>
        </div>
      </form>
    </div>

    <x-partial.table-content>
      <thead>
        <tr>
          <th class="w-200px">Tanggal</th>
          <th>Keuntungan Ditarik</th>
          <th>Ditarik Oleh</th>
          <th class="w-200px">Bukti Transfer</th>
        </tr>
      </thead>
      <tbody>
        @foreach ($collection as $item)
          <tr>
            <td>{{date('d/m/Y', strtotime($item->date))}}</td>
            <td>{{number_format($item->nominal)}}</td>
            <td>{{$item->admin->name}}</td>
            <td>
              <button type="button"class="btn btn-primary popup_image"
                data-src="{{_asset('img/AdminLTELogo.png')}}">
                <i class="fas fa-image"></i>
              </button>
            </td>
          </tr>
        @endforeach
      </tbody>
    </x-partial.table-content>
    <div class="mt-2">
      {{$collection->links('vendor.pagination.bootstrap-5')}}
    </div>
  </section>

  <x-slot name="css">
    <link rel="stylesheet" type="text/css" href="{{_asset('plugins/w2ui/style.css')}}">
  </x-slot>

  <x-slot name="js">
    <script type="text/javascript" src="https://w2ui.com/src/w2ui-1.4.2.min.js"></script>
    <script type="text/javascript" src="{{_asset('js/crud/post.js?ls=24231fef__')}}"></script>
    <script>
      $(document).ready(function() {

        $(".popup_image").on('click', function() {
          w2popup.open({
            title: 'Image',
            body: '<div class="w2ui-centered"><img src="' + $(this).data('src') + '"></img></div>'
          });
        });

      });
    </script>
  </x-slot>

</x-layout>