<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <x-revenue.form-subscribe :conf="$conf" />

    <div class="card" id="sectionSearch">
      <div class="card-header bg-warning">
        <h4 class="card-title text-white">Pencarian Data</h4>
      </div>
      <form method="get">
        <div class="card-body">
          <div class="row">
            <x-form.input 
              div="col-md-2" label="Tanggal Mulai" id="start_date" offrequired
              name="start_date" type="date" value="{{$_GET['start_date'] ?? ''}}" />
            <x-form.input 
              div="col-md-2" label="Tanggal Akhir" id="end_date" offrequired
              name="end_date" type="date" value="{{$_GET['end_date'] ?? ''}}" />
            <x-form.input 
              div="col-md-4" label="Bank" placeholder="Bank"
              name="bank" value="{{$_GET['bank'] ?? ''}}" offrequired />
            <x-form.input 
              div="col-md-4" label="Atas Nama" placeholder="Atas Nama"
              name="an" value="{{$_GET['an'] ?? ''}}" offrequired />
            <input type="hidden" name="_activity" value="search" />
          </div>
        </div>
        <div class="card-footer">
          <a href="{{url('revenue/subscription')}}" class="btn btn-danger text-white">Hapus Pencarian</a>
          <button type="submit" class="btn btn-warning text-white">Cari Data</button>
        </div>
      </form>
    </div>

    <x-partial.table-content>
      <thead>
        <tr>
          <th class="w-200px">Tanggal</th>
          <th>Nominal Penarikan</th>
          <th>Fee</th>
          <th>Atas Nama</th>
          <th>Bank</th>
          <th>Status</th>
        </tr>
      </thead>
      <tbody>
        @foreach ($collection as $item)
          <tr>
            <td>{{date('d/m/Y', strtotime($item->created_at))}}</td>
            <td>{{number_format($item->nominal)}}</td>
            <td>{{number_format($item->fee)}}</td>
            <td>{{$item->account_name}}</td>
            <td>{{$item->bank->title}}</td>
            <td>{{$item->result_json['status']}}</td>
          </tr>
        @endforeach
      </tbody>

      <x-slot name="extra">
        {{$collection->links('vendor.pagination.bootstrap-5')}}
      </x-slot>
    </x-partial.table-content>
  </section>

  <x-slot name="js">
    <script type="text/javascript" src="{{_asset('js/crud/post.js')}}"></script>
    <script type="text/javascript" src="{{_asset('js/rupiah.js')}}"></script>
    <script type="text/javascript" src="{{_asset('js/revenue-subscribe.js')}}"></script>
  </x-slot>

</x-layout>