<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <x-revenue.form action="{{$type}}" />

    <div class="card" id="sectionSearch">
      <div class="card-header bg-warning">
        <h4 class="card-title text-white">Pencarian Data</h4>
      </div>
      <form method="get">
        <div class="card-body">
          <div class="row">
            <x-form.input 
              div="col-md-2" label="Tanggal Mulai" id="start_date" offrequired
              name="start_date" type="date" value="{{$_GET['start_date'] ?? ''}}" />
            <x-form.input 
              div="col-md-2" label="Tanggal Akhir" id="end_date" offrequired
              name="end_date" type="date" value="{{$_GET['end_date'] ?? ''}}" />
            <x-form.input 
              div="col-md-4" label="Pengguna" placeholder="Nama pengguna"
              name="user" value="{{$_GET['user'] ?? ''}}" offrequired />
            <x-form.input 
              div="col-md-4" label="Ditarik Oleh" placeholder="Ditarik Oleh"
              name="admin" value="{{$_GET['admin'] ?? ''}}" offrequired />
            <input type="hidden" name="_activity" value="search" />
          </div>
        </div>
        <div class="card-footer">
          <a href="{{url('revenue/'.$type)}}" class="btn btn-danger text-white">Hapus Pencarian</a>
          <button type="submit" class="btn btn-warning text-white">Cari Data</button>
        </div>
      </form>
    </div>

    <x-partial.table-content>
      <thead>
        <tr>
          <th class="w-200px">Tanggal</th>
          <th>Nominal Penarikan</th>
          <th>Pengguna</th>
          <th>Ditarik Oleh</th>
          <th class="w-200px">Bukti Transfer</th>
        </tr>
      </thead>
      <tbody>
        @foreach ($collection as $item)
          <tr>
            <td>{{date('d/m/Y', strtotime($item->date))}}</td>
            <td>{{number_format($item->nominal)}}</td>
            <td>{{$item->user->name}}</td>
            <td>{{$item->admin->name}}</td>
            <td>
              <button type="button"class="btn btn-primary popup_image"
                data-src="{{base_url($item->file)}}">
                <i class="fas fa-image"></i>
              </button>
            </td>
          </tr>
        @endforeach
      </tbody>

      <x-slot name="extra">
        {{$collection->links('vendor.pagination.bootstrap-5')}}
      </x-slot>
    </x-partial.table-content>
  </section>

  <x-slot name="css">
    <link rel="stylesheet" type="text/css" href="{{_asset('plugins/w2ui/style.css')}}">
  </x-slot>

  <x-slot name="js">
    <script type="text/javascript" src="{{_asset('js/date-input.js')}}"></script>
    <script type="text/javascript" src="https://w2ui.com/src/w2ui-1.4.2.min.js"></script>
    <script type="text/javascript" src="{{_asset('js/crud/post.js?ls=24231fef__')}}"></script>
    <script>
      $(document).ready(function() {

        $(".popup_image").on('click', function() {
          w2popup.open({
            title: 'Image',
            body: '<div class="w2ui-centered"><img src="' + $(this).data('src') + '"></img></div>'
          });
        });

        var currentUrl = window.location.href
        var currentParams = new URL(currentUrl);
        if (currentParams.searchParams.get("_activity") === 'search') {
          $("html, body").animate({
            scrollTop: $('html, body').get(0).scrollHeight
          }, 1500);
        }

      });
    </script>
  </x-slot>

</x-layout>