<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="row">

      <x-partial.button-add 
        class="col-md-2 col-12 mb-3"
        href="sliders/add" />

      <x-search.slider class="col-md-10 col-12 mb-3" />

      <div class="col-12 mb-3">
        <x-partial.table-content>
          <thead>
            <tr>
              <th class="w-10px">No</th>
              <th>Slider</th>
              <th class="w-50px">Status</th>
              <th class="w-300px">Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($collection as $key => $item)
              <tr id="data-{{$item->id}}">
                <td class="numbering">{{no($key)}}</td>
                <td>
                  <img 
                    src="{{_asset($item->file)}}" 
                    class="w-100px" 
                    alt="slider {{$item->id}}" />
                </td>
                <td class="text-center">
                  {!! active($item->active) !!}
                </td>
                <td id="action-{{$item->id}}">
                  <a 
                    href="{{$item->url}}" 
                    target="_blank" 
                    class="btn btn-warning btn-sm">
                    <i class="fas fa-link mr-2"></i>
                    Url
                  </a>

                  <x-partial.button-edit href="sliders/edit/{{$item->id}}" />

                  <x-partial.button-delete
                    action="sliders/_delete"
                    id="{{$item->id}}" />
                </td>
              </tr>
            @endforeach
          </tbody>
        </x-partial.table-content>
      </div>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/delete.js')}}" 
      element="table"></script>
  </x-slot>

</x-layout>