<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}" 
    :items="[
      [$title, url('subscriptions')],
      ['Edit']
    ]" />

  <section class="content px-3">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">Edit {{$title}}</h3>
      </div>
      <form 
        class="_form" 
        action="{{url('subscriptions/_update')}}" 
        method="post">
        <div class="card-body">
          <input type="hidden" name="id" value="{{$item->id}}" />
          <x-form.input 
            label="Judul" 
            name="title" value="{{$item->title}}"
            placeholder="Masukan Judul" />
          <div class="row">
            <x-form.input 
              label="Harga" div="col-md-6"
              name="price" type="number" value="{{$item->price}}"
              placeholder="Masukan Harga" />
            <x-form.input 
              label="Durasi (BULAN)" div="col-md-6"
              name="duration" value="{{$item->duration}}"
              placeholder="Masukan Durasi" />
          </div>
          <div class="form-group">
            <label for="descriptionTextarea">Deskripsi</label>
            <textarea name="description" id="descriptionTextarea" class="form-control" rows="5" placeholder="Masukan Deskripsi">{{$item->description}}</textarea>
          </div>
        <div class="card-footer">
          <a 
            onclick="return history.go(-1)" 
            class="btn btn-default" 
            id="_backButton">Kembali</a>
          <button 
            type="submit" 
            class="btn btn-primary" 
            id="_button">Simpan</button>
        </div>
      </form>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
  </x-slot>
</x-layout>