<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="card">
      <form action="{{url('top-up/store')}}" method="post" class="_form">
        <div class="card-body">
          <x-form.input 
            label="Nominal TopUp" name="nominal" 
            placeholder="Masukan Nominal TopUp" />
          <x-form.input 
            readonly label="TopUp Oleh" value="{{auth()->user()->name}}" />
          <div class="card">
            <div class="card-header d-flex p-0">
              <h3 class="card-title p-3">Metode Pembayaran</h3>
              <ul class="nav nav-pills ml-auto p-2">
                @foreach ($payments as $index => $payment)
                  <li class="nav-item">
                    <a class="nav-link {{!$index ? 'active' : ''}}" href="#payment-{{$payment->id}}-tab" data-toggle="tab">{{$payment->name}}</a>
                  </li>
                @endforeach
              </ul>
            </div>
            <div class="card-body">
              <div class="tab-content">
                @foreach ($payments as $index => $payment)
                  <div class="tab-pane {{!$index ? 'active' : ''}}" id="payment-{{$payment->id}}-tab">
                    <div class="row">
                      @foreach ($payment->items as $item)
                        <div class="col-md-4 mb-3">
                          <input type="radio" name="payment" id="payment-{{$item->id}}" value="{{$item->id}}" class="d-none" />
                          <label class="payment-method" for="payment-{{$item->id}}">
                            <img src="{{base_url($item->file)}}" alt="metode pembayaran" class="d-none" />
                            <h5 class="text-uppercase mb-0 text-bold">{{$item->title}}</h5>
                            <small>{{$item->code}}</small>
                          </label>
                        </div>
                      @endforeach
                    </div>
                  </div>
                @endforeach
              </div>
            </div>
          </div>
        </div>
        <div class="card-footer">
          <button type="submit" class="btn btn-primary">TopUp</button>
        </div>
      </form>
    </div>

    <x-partial.table-content>
      <thead>
        <tr>
          <th class="w-200px">Tanggal</th>
          <th>Nominal TopUp</th>
          <th>Metode Pembayaran</th>
          <th>Kode</th>
          <th>TopUp Oleh</th>
          <th class="w-200px">Bukti Transfer</th>
        </tr>
      </thead>
      <tbody>
        @foreach ($collection as $item)
          <tr>
            <td>{{date('d/m/Y', strtotime($item->date))}}</td>
            <td>{{number_format($item->nominal)}}</td>
            <td>{{$item->payment['title']}}</td>
            <td>
              {{$item->payment['type'] == 'transfer_va' ? $item->external_id : 
              ($item->payment['type'] == 'cstore' ? $item->response['payment_code'] : '-')}}
            </td>
            <td>{{$item->admin->name}}</td>
            <td>
              @if ($item->proof_of_payment)
                <button type="button"class="btn btn-primary popup_image"
                  data-src="{{base_url($item->proof_of_payment)}}">
                    <i class="fas fa-image"></i>
                  </button>
              @else
                <a href="{{url('top-up/proof-of-payment/'.$item->id)}}" class="btn btn-primary">
                  Tambahkan
                </a>
              @endif
            </td>
          </tr>
        @endforeach
      </tbody>
    </x-partial.table-content>
    <div class="mt-2">
      {{$collection->links('vendor.pagination.bootstrap-5')}}
    </div>
  </section>

  <x-slot name="css">
    <link rel="stylesheet" type="text/css" href="{{_asset('plugins/w2ui/style.css')}}">
  </x-slot>

  <x-slot name="js">
    <script type="text/javascript" src="https://w2ui.com/src/w2ui-1.4.2.min.js"></script>
    <script type="text/javascript" src="{{_asset('js/crud/post.js?ls=24231fef__')}}"></script>
    <script>
      $(document).ready(function() {

        $(".popup_image").on('click', function() {
          w2popup.open({
            title: 'Image',
            body: '<div class="w2ui-centered"><img src="' + $(this).data('src') + '"></img></div>'
          });
        });

      });
    </script>
  </x-slot>

</x-layout>