<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title, url('users')],
      ['Tambah']
    ]" /> 

  <section class="content px-3">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">Tambah {{$title}}</h3>
      </div>
      <form 
        class="_form" 
        action="{{url('users/_create')}}" 
        method="post">
        <div class="card-body row">
          <x-form.input
            div="col-md-6" 
            label="Nama" 
            name="name" 
            placeholder="Masukan nama" />
          <x-form.input
            div="col-md-6" 
            type="email" name="email" 
            label="Email" 
            placeholder="Masukan email" />
          <x-form.input
            div="col-md-6" 
            type="password" name="password" 
            label="Password" 
            placeholder="Masukan password" />
          <x-form.select
            div="col-md-6" 
            label="Otoritas Fitur" 
            name="authorities_id" 
            :collection="$authority" 
            :option="['id', ['title']]" />
        </div>
        <div class="card-footer">
          <a 
            onclick="return history.go(-1)" 
            class="btn btn-default" 
            id="_backButton">Kembali</a>
          <button 
            type="submit" 
            class="btn btn-primary" 
            id="_button">Simpan</button>
        </div>
      </form>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
  </x-slot>
</x-layout>