<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="row">

      <x-partial.button-add 
        class="col-md-2 col-12 mb-3"
        href="users/add" />

      <x-search.users class="col-md-10 col-12 mb-3" />

      <div class="col-12 mb-3">
        <x-partial.table-content>
          <thead>
            <tr>
              <th class="w-10px">No</th>
              <th>Nama</th>
              <th>Otoritas Fitur</th>
              <th>Email</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($collection as $key => $item)
              <tr id="data-{{$item->id}}">
                <td class="numbering w-10px">{{no($key)}}</td>
                <td>{{$item['name']}}</td>
                <td>{{$item['authority']['title'] ?? ''}}</td>
                <td>{{$item['email']}}</td>
                <td id="action-{{$item->id}}">
                  <x-partial.button-edit href="users/edit/{{$item->id}}" />

                  <form style="display: inline-block" action="{{url('users/_status')}}" data-id="{{$item->id}}" class="activeForm mt-1">
                    <button type="submit" class="btn btn-{{$item['active'] == 'yes' ? 'danger' : 'success'}} btn-sm" id="active-{{$item['id']}}">
                      <i class="fas fa-{{$item['active'] == 'yes' ? 'times' : 'check'}}"></i>&nbsp;&nbsp;{{$item['active'] == 'yes' ? 'Matikan' : 'Aktifkan'}}
                    </button>
                  </form>
                </td>
              </tr>
            @endforeach
          </tbody>

          <x-slot name="extra">
            {{$collection->links('vendor.pagination.bootstrap-5')}}
          </x-slot>
        </x-partial.table-content>
      </div>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/active.js')}}"></script>
  </x-slot>
</x-layout>