<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title, url('vendor')],
      [$item->name_vendor]
    ]" /> 

  <section class="content px-3">
    <div class="card">
      <div class="card-body">
        <p class="text-bold mb-3">Dibuat Oleh : <u>{{$item->user->name}}</u></p>

        <img 
          class="mb-3" style="width: 150px;"
          src="{{$item->avatar_image}}" alt="avatar" />

        <h5 class="text-bold mb-3">PROFILE</h5>
        <div class="row">
          <x-form.input 
            label="Nama Vendor"
            div="col-md-6" readonly
            value="{{$item->name_vendor ?? '-'}}" />
          <x-form.input 
            label="Kategori Vendor"
            div="col-md-6" readonly
            value="{{$item->category?->title ?? '-'}}" />
          <x-form.input 
            label="PIC (nama lengkap)"
            div="col-md-6" readonly
            value="{{$item->pic ?? '-'}}" />
          <x-form.input 
            label="No. Handphone"
            div="col-md-6" readonly
            value="{{$item->phone_number ?? '-'}}" />
        </div>

        <h5 class="text-bold mt-4 mb-3">ALAMAT VENDOR</h5>
        <div class="row">
          <x-form.input 
            label="Provinsi"
            div="col-md-4" readonly
            value="{{$item->address?->province?->province_name ?? '-'}}" />
          <x-form.input 
            label="Kota / Kabupaten"
            div="col-md-4" readonly
            value="{{$item->address?->city?->city_name ?? '-'}}" />
          <x-form.input 
            label="Kecamatan"
            div="col-md-4" readonly
            value="{{$item->address?->subdistrict?->subdistrict_name ?? '-'}}" />
          <x-form.input 
            label="Desa"
            div="col-md-4" readonly
            value="{{$item->address?->village ?? '-'}}" />
          <x-form.input 
            label="RT"
            div="col-md-4" readonly
            value="{{$item->address?->rt ?? '-'}}" />
          <x-form.input 
            label="RW"
            div="col-md-4" readonly
            value="{{$item->address?->rw ?? '-'}}" />
          <x-form.input 
            label="Kode POS"
            div="col-md-4" readonly
            value="{{$item->address?->postcode ?? '-'}}" />
          <x-form.input 
            label="Latitude"
            div="col-md-4" readonly
            value="{{$item->address?->latitude ?? '-'}}" />
          <x-form.input 
            label="Longitude"
            div="col-md-4" readonly
            value="{{$item->address?->longitude ?? '-'}}" />
          <x-form.input 
            label="Alamat Lengkap"
            div="col-md-12" readonly
            value="{{$item->address?->address ?? '-'}}" />
        </div>

        <h5 class="text-bold mt-4 mb-3">AKUN BANK</h5>
        <div class="row">
          <x-form.input 
            label="Nama Bank"
            div="col-md-3" readonly
            value="{{$item->account?->bank_as?->name ?? '-'}}" />
          <x-form.input 
            label="Cabang"
            div="col-md-2" readonly
            value="{{$item->account?->branch ?? '-'}}" />
          <x-form.input 
            label="Nama Rekening"
            div="col-md-5" readonly
            value="{{$item->account?->names ?? '-'}}" />
          <x-form.input 
            label="No. Rekening"
            div="col-md-2" readonly
            value="{{$item->account?->account_number ?? '-'}}" />
        </div>
      </div>
      <div class="card-footer">
        <a 
          onclick="return history.go(-1)" 
          class="btn btn-default" 
          id="_backButton">Kembali</a>
      </div>
    </div>


  </section>

</x-layout>