<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="row">

      <div class="col-12">
        <x-search url="venture/subscription">
          <x-form.input 
            div="col-md-6" class=""
            label="Nama User" name="user" 
            placeholder="Masukan nama user" offrequired
            value="{{$_GET['user'] ?? ''}}" />
          <x-form.input 
            div="col-md-6" class=""
            label="Langganan" name="subscription" 
            placeholder="Masukan langganan" offrequired
            value="{{$_GET['subscription'] ?? ''}}" />
        </x-search>
      </div>

      {{-- <x-search.withdraw class="col-md-12 col-12 mb-3" /> --}}

      <div class="col-12 mb-3">
        <x-partial.table-content>
          <thead>
            <tr>
              <th class="w-10px">No</th>
              <th>User</th>
              <th>Langganan</th>
              <th>Harga</th>
              <th>Berakhir</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($collection as $key => $item)
              <tr id="data-{{$item->id}}">
                <td class="numbering w-10px">{{no($key)}}</td>
                <td>{{$item->user->name}}</td>
                <td><b>{{$item->subscription->title}}</b>: {{$item->subscription->description}}</td>
                <td>{{number_format($item->total_price)}}</td>
                <td>{{$item->expired_at}}</td>
              </tr>
            @endforeach
          </tbody>

          <x-slot name="extra">
            {{$collection->links('vendor.pagination.bootstrap-5')}}
          </x-slot>
        </x-partial.table-content>
      </div>
    </div>
  </section>

</x-layout>