<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title, url('users')],
      ['Status Kerjasama : ' . $item->name]
    ]" /> 

  <section class="content px-3">
    <x-venture.user.cooperation id="{{$item->id}}" 
        action="{{($item->skema != 'kepemilikan_saham') ? 'ventures/_cooperation' : ''}}">
      @if ($item->skema != 'kepemilikan_saham')
        <x-form.select
          label="Skema" name="skema"
          :collection="config('select.SKEMA_VENTURE')" 
          :option="['id', ['text']]"
          value="{{$item->skema ?? ''}}" />
      @else
        <x-form.input label="Skema" value="Kepemilikan Saham" readonly />
      @endif
      
    </x-venture.user.cooperation>

    <x-venture.user.cooperation id="{{$item->id}}" action="ventures/_cooperation">
      <h4>Porsi Pembagian</h4>
      <div class="row">
        <x-form.input 
          label="Untuk Pengguna" name="share_portion" step=".01"
          type="number" placeholder="Masukan porsi untuk pengguna"
          value="{{$item->share_portion ?? ''}}" div="col-md-6" />
        <x-form.input 
          label="Untuk WE-HUB" name="wehub_portion"
          type="text" placeholder="..." readonly
          value="{{$item->wehub_portion ?? ''}}" div="col-md-6" />
      </div>
    </x-venture.user.cooperation>

    <x-venture.user.cooperation id="{{$item->id}}" action="ventures/_cooperation">
      <div class="form-group col-md-6">
        <label for="file">PKS</label>
        <br />
        <input type="file" name="pks" />
        <br />
        <a href="{{base_url($item->pks)}}" target="_blank">
          {{str_replace('pks/', '', $item->pks)}}
        </a>
      </div>
    </x-venture.user.cooperation>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
    <script>
      $(document).ready(function() {
        $(`input[name="share_portion"]`).on('input', function(){
          $(`input[name="wehub_portion"]`).val(100 - $(this).val());
        });
      });
    </script>
  </x-slot>
</x-layout>