<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title, url('users')],
      [$item->name]
    ]" /> 

  <section class="content px-3">
    
    <div class="card card-primary">
      <div class="card-body">
        {{-- PROFILE --}}
        <h5 class="text-bold mb-3">PROFILE</h5>
        
        @if(!empty($item?->profile))
          <div class="mb-3">
            <label>Foto Profile</label>
            <div>
              <img 
                src="{{base_url($item->profile)}}" 
                class="preview-img" />
            </div>
          </div>
        @endif
    
        <div class="row">
          <x-form.input 
            div="col-md-4" readonly
            label="Profesi" value="{{$item->profession?->title ?? ''}}" />
          <x-form.input 
            div="col-md-4" readonly
            label="Nama Depan" value="{{$item->front_name ?? ''}}" />
          <x-form.input 
            div="col-md-4" readonly
            label="Nama Belakang" value="{{$item->back_name ?? ''}}" />
    
          <x-form.input 
            div="col-md-4" readonly
            label="NIK" value="{{$item->nik ?? ''}}" />
          <x-form.input 
            div="col-md-4" readonly
            label="No. Handphone" value="{{$item->phone_number ?? ''}}" />
          <x-form.input 
            div="col-md-4" readonly
            label="Email" value="{{$item->email ?? ''}}" />
        </div>
        <div class="row">
          @if(!empty($item?->ktp))
            <div class="col-md-6">
              <label>KTP</label>
              <div>
                <img 
                  src="{{base_url($item->ktp)}}" 
                  class="preview-img" />
              </div>
            </div>
          @endif

          @if(!empty($item?->npwp))
            <div class="col-md-6">
              <label>NPWP</label>
              <div>
                <img 
                  src="{{base_url($item->npwp)}}" 
                  class="preview-img" />
              </div>
            </div>
          @endif
        </div>
        {{-- PROFILE USAHA --}}
        <h5 class="text-bold mt-3 mb-3">PROFILE USAHA</h5>

        @if(!empty($item?->bussines?->profile_bussines))
          <div class="col-md-6">
            <label>Foto Usaha</label>
            <div>
              <img 
                src="{{base_url($item->bussines?->profile_bussines)}}" 
                class="preview-img" />
            </div>
          </div>
        @endif

        <div class="row">
          <x-form.input 
            div="col-md-6" readonly label="Nama Usaha" 
            value="{{$item?->bussines?->name_bussines ?? '...'}} by {{$configuration->title}}" />
          <x-form.input 
            div="col-md-6" readonly label="Provinsi" 
            value="{{$item?->bussines?->province?->province_name ?? ''}}" />
          <x-form.input 
            div="col-md-6" readonly label="Kota / Kabupaten" 
            value="{{$item?->bussines?->city?->city_name ?? ''}}" />
          <x-form.input 
            div="col-md-6" readonly label="Kecamatan" 
            value="{{$item?->bussines?->subdistrict?->subdistrict_name ?? ''}}" />
          <x-form.input 
            div="col-md-6" readonly label="Desa / Kelurahan" 
            value="{{$item?->bussines?->village ?? ''}}" />
          <x-form.input 
            div="col-md-6" readonly label="Kode POS" 
            value="{{$item?->bussines?->postcode ?? ''}}" />
          <x-form.input 
            div="col-md-12" readonly label="Alamat Lengkap" 
            value="{{$item?->bussines?->address ?? ''}}" />
          <x-form.input 
            div="col-md-6" readonly label="Latitude" 
            value="{{$item?->bussines?->latitude ?? ''}}" />
          <x-form.input 
            div="col-md-6" readonly label="Longitude" 
            value="{{$item?->bussines?->longitude ?? ''}}" />
        </div>
        
        <div class="row">
          @if(!empty($item?->bussines?->akta))
            <div class="col-md-3">
              <label>Akta</label>
              <div>
                <img 
                  src="{{base_url($item->bussines?->akta)}}" 
                  class="preview-img" />
              </div>
            </div>
          @endif

          @if(!empty($item?->bussines?->npwp_bussines))
            <div class="col-md-3">
              <label>NPWP</label>
              <div>
                <img 
                  src="{{base_url($item->bussines?->npwp_bussines)}}" 
                  class="preview-img" />
              </div>
            </div>
          @endif

          @if(!empty($item?->bussines?->nib))
            <div class="col-md-3">
              <label>NIB</label>
              <div>
                <img 
                  src="{{base_url($item->bussines?->nib)}}" 
                  class="preview-img" />
              </div>
            </div>
          @endif

          @if(!empty($item?->bussines?->sk_kemenkum))
            <div class="col-md-3">
              <label>SK Kemenkum</label>
              <div>
                <img 
                  src="{{base_url($item->bussines?->sk_kemenkum)}}" 
                  class="preview-img" />
              </div>
            </div>
          @endif
        </div>
        {{-- AKUN BANK --}}
        <h5 class="text-bold mt-3 mb-3">AKUN BANK</h5>
        <div class="row">
          <x-form.input 
            div="col-md-6" readonly
            label="Bank" value="{{$item?->account?->bank_as?->name ?? ''}}" />
          <x-form.input 
            div="col-md-6" readonly
            label="Cabang" value="{{$item?->account?->branch ?? ''}}" />
          <x-form.input 
            div="col-md-6" readonly
            label="Nama Rekening" value="{{$item?->account?->names ?? ''}}" />
          <x-form.input 
            div="col-md-6" readonly
            label="No. Rekening" value="{{$item?->account?->account_number ?? ''}}" />
        </div>
      </div>
      <div class="card-footer">
        <a 
          onclick="return history.go(-1)" 
          class="btn btn-default" 
          id="_backButton">Kembali</a>
      </div>
    </div>
  </section>

</x-layout>
