<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title, url('users')],
      ['Modal Disetor']
    ]" /> 

  <section class="content px-3">
    <x-venture.user.wallet.form :item="$e" />

    <div class="card">
      <form method="get">
        <div class="card-body">
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="file">Periode</label>
                <select name="periode" class="form-control">
                  @for ($i = 1; $i <= 12; $i++)
                    @php
                      $month = ($i < 10 ? '0'.$i : $i);
                    @endphp
                    <option @if (($_GET['periode'] ?? date('m')) == $month)
                      selected
                    @endif>{{bulan(date('Y-').$month)}}</option>
                  @endfor
                </select>
              </div>
            </div>
            <div class="col-md-6">
              <label>&nbsp;</label>
              <br />
              <button type="submit" class="btn btn-primary">Cari</button>
            </div>
          </div>
        </div>
      </form>
    </div>
    

    <x-partial.table-content>
      <thead>
        <tr>
          <th class="w-10px">No</th>
          <th>Tanggal</th>
          <th>Modal Disetor</th>
          <th class="w-100px">Biaya Modal %</th>
          <th>Hasil</th>
          <th class="w-100px">Bukti Transfer</th>
        </tr>
      </thead>
      <tbody>
        @foreach ($collection as $index => $item)
          <tr>
            <td>{{no($index)}}</td>
            <td>{{tgl($item->created_at, 'full')}}</td>
            <td>{{number_format($item->setor)}}</td>
            <td>{{$item->modal}}%</td>
            <td>{{number_format($item->result)}}</td>
            <td>
              <button type="button"class="btn btn-primary popup_image"
                data-src="{{env('URL_ASSET').$item->file}}" data-title="Bukti Transfer">
                <i class="fas fa-image"></i>
              </button>
            </td>
          </tr>
        @endforeach
      </tbody>
      <tfoot>
        <th colspan="4">Total Hasil</th>
        <th colspan="2">Rp {{number_format($total)}}</th>
      </tfoot>
    </x-partial.table-content>
  </section>

  <x-slot name="css">
    <link rel="stylesheet" type="text/css" href="{{_asset('plugins/w2ui/style.css')}}">
  </x-slot>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
    <script type="text/javascript" src="https://w2ui.com/src/w2ui-1.4.2.min.js"></script>
    <script type="text/javascript" src="{{_asset('js/w2popup.js')}}"></script>
  </x-slot>
</x-layout>