<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title, url('withdraw')],
      ['Tangani']
    ]" /> 

  <section class="content px-3">
    <div class="card card-primary">
      <div class="card-header">
        <h3 class="card-title">{{$title}}</h3>
      </div>
      <form
        class="_form" 
        action="{{url('venture/withdraw/_handle')}}" 
        method="post">
        <div class="card-body">
          <p class="text-bold mb-3">Dibuat Oleh : <u>{{$item->user->name}}</u></p>
          <div class="row">
            <x-form.input 
              label="Atas Nama"
              div="col-md-4" readonly
              value="{{$item->account['bank']}} {{$item->account['branch']}}" />
            <x-form.input 
              label="Atas Nama"
              div="col-md-4" readonly
              value="{{$item->account['names']}}" />
            <x-form.input 
              label="No. Rekening"
              div="col-md-4" readonly
              value="{{$item->account['account_number']}}" />
          </div>
          <h5 class="mb-3">
            <span class="text-bold">Nominal :</span> 
            <span><u>Rp {{number_format($item->nominal)}}</u></span>
          </h5>
          <div class="row">
            <x-form.select
              label="Status Tarik Dana" div="col-md-6"
              name="status" :option="['id', ['text']]" value="{{$item->status}}"
              :collection="config('select.STATUS_WITHDRAW')" />
            <x-form.input 
              label="Ditangani Oleh"
              div="col-md-6" readonly
              value="{{auth()->user()->name}}" />
          </div>
          <input type="hidden" name="id" value="{{$item->id}}" required />
        </div>
        <div class="card-footer">
          <a 
            onclick="return history.go(-1)" 
            class="btn btn-default" 
            id="_backButton">Kembali</a>
          <button 
            type="submit" 
            class="btn btn-primary" 
            id="_button">Simpan</button>
        </div>
      </form>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" 
      src="{{_asset('js/crud/post.js')}}"></script>
  </x-slot>
</x-layout>