<x-layout title="{{$title}}">

  <x-breadcrumb 
    title="{{$title}}"
    :items="[
      [$title]
    ]" /> 

  <section class="content px-3">
    <div class="row">

      <x-search.withdraw class="col-md-12 col-12 mb-3" />

      <div class="col-12 mb-3">
        <x-partial.table-content>
          <thead>
            <tr>
              <th class="w-10px">No</th>
              <th>Dibuat Oleh</th>
              <th>Nominal</th>
              <th>Tujuan</th>
              <th>Status</th>
              <th>Aksi</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($collection as $key => $item)
              <tr id="data-{{$item->id}}">
                <td class="numbering w-10px">{{no($key)}}</td>
                <td>{{$item->user->name}}</td>
                <td>{{number_format($item->nominal)}}</td>
                <td>
                  {{$item->account['bank']}} {{$item->account['branch']}} . {{$item->account['names']}} a/n {{$item->account['account_number']}}
                </td>
                <td>{!! $item->status_html !!}</td>
                <td id="action-{{$item->id}}">
                  @if ($item->status == 'pending')
                    <a 
                      href="{{url('venture/withdraw/handle/'.$item->id)}}" 
                      class="btn btn-warning btn-sm">
                      <i class="fas fa-check mr-2"></i>
                      Tangani
                    </a>
                  @endif
                </td>
              </tr>
            @endforeach
          </tbody>

          <x-slot name="extra">
            {{$collection->links('vendor.pagination.bootstrap-5')}}
          </x-slot>
        </x-partial.table-content>
      </div>
    </div>
  </section>

  <x-slot name="js">
    <script 
      type="text/javascript" element="table"
      src="{{_asset('js/crud/delete.js')}}"></script>
  </x-slot>

</x-layout>