<?php

use App\Http\Controllers\ArController;
use App\Http\Controllers\AreaController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\AuthorityController;
use App\Http\Controllers\BankController;
use App\Http\Controllers\BranchController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\ConfigurationController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Opex\PengeluaranController as OpexPengeluaran;
use App\Http\Controllers\PaymentMethodController;
use App\Http\Controllers\PaymentMethodTypeController;
use App\Http\Controllers\PdfController;
use App\Http\Controllers\Product\PackageController;
use App\Http\Controllers\Product\ProductController;
use App\Http\Controllers\Product\UnitController;
use App\Http\Controllers\ProfessionController;
use App\Http\Controllers\PurchaseOrderController;
use App\Http\Controllers\RevenueController;
use App\Http\Controllers\ShoppingController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\TopUpController;
use App\Http\Controllers\VendorController;
use App\Http\Controllers\VentureController;
use App\Http\Controllers\WithdrawController;
use App\Http\Controllers\WithdrawSubscribeController;
use App\Http\Controllers\XenditController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::post('/xendit-service-webhooks', [XenditController::class, 'webhooks']);

Route::get('/', [AuthController::class, 'index'])->name('login');
Route::post('/_signin', [AuthController::class, 'run'])->name('_signin');

Route::prefix('pdf')->group(function () {
  Route::get('view', [PdfController::class, 'view']);
  Route::get('download', [PdfController::class, 'download']);
});

Route::get('/privacy-policy', function () {
  return view('privacy');
})->name('privacy');

Route::middleware(['auth:sanctum', 'verified'])->group(function () {

  Route::prefix('area')->name('product')->controller(AreaController::class)->group(function () {
    Route::get('/city', 'city');
    Route::get('/subdistrict', 'subdistrict');
  });

  Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

  Route::prefix('profile')->group(function () {
    Route::get('/', [ProfileController::class, 'profile'])->name('profile');
    Route::post('/_edit', [ProfileController::class, 'edit']);
    Route::post('/_password', [ProfileController::class, 'password']);
  });

  Route::get('/logout', [AuthController::class, 'logout'])->name('logout');

  Route::get('/getUser', [VentureController::class, 'getUser']);
  
  Route::middleware(['authority.validation'])->group(function () {
    Route::prefix('authority')->group(function () {
      Route::get('/', [AuthorityController::class, 'index'])->name('authority');
      Route::get('/add', [AuthorityController::class, 'add'])->name('authority');
      Route::post('/_create', [AuthorityController::class, 'create'])->name('authority');
      Route::post('/_delete', [AuthorityController::class, 'delete'])->name('authority');
      Route::get('/edit/{id}', [AuthorityController::class, 'edit'])->name('authority');
      Route::post('/_edit', [AuthorityController::class, 'update'])->name('authority');
    });

    Route::prefix('users')->group(function () {
      Route::get('/', [UserController::class, 'index'])->name('users');
      Route::get('/add', [UserController::class, 'add'])->name('users');
      Route::get('/edit/{id}', [UserController::class, 'edit'])->name('users');
      Route::post('/_create', [UserController::class, 'create'])->name('users');
      Route::post('/_status', [UserController::class, 'status'])->name('users');
      Route::post('/_edit', [UserController::class, 'update'])->name('users');
      Route::post('/_password', [UserController::class, 'password'])->name('users');
    });

    Route::prefix('sliders')->group(function () {
      Route::get('/', [SliderController::class, 'index'])->name('slider');
      Route::get('/add', [SliderController::class, 'add'])->name('slider');
      Route::get('/edit/{id}', [SliderController::class, 'edit'])->name('slider');
      Route::post('/_create', [SliderController::class, 'create'])->name('slider');
      Route::post('/_edit', [SliderController::class, 'update'])->name('slider');
      Route::post('/_delete', [SliderController::class, 'delete'])->name('slider');
    }); 

    Route::prefix('configuration')->group(function () {
      Route::get('/', [ConfigurationController::class, 'index'])->name('configuration');
      Route::post('/store', [ConfigurationController::class, 'store'])->name('configuration');
    });

    Route::prefix('banks')->group(function () {
      Route::get('/', [BankController::class, 'index'])->name('bank');
      Route::get('/add', [BankController::class, 'add'])->name('bank');
      Route::get('/edit/{id}', [BankController::class, 'edit'])->name('bank');
      Route::post('/_store', [BankController::class, 'store'])->name('bank');
      Route::post('/_update', [BankController::class, 'update'])->name('bank');
      Route::post('/_delete', [BankController::class, 'delete'])->name('bank');
    });

    Route::prefix('categories')->group(function () {
      Route::get('/', [CategoryController::class, 'index'])->name('category');
      Route::get('/add', [CategoryController::class, 'add'])->name('category');
      Route::get('/edit/{id}', [CategoryController::class, 'edit'])->name('category');
      Route::post('/_store', [CategoryController::class, 'store'])->name('category');
      Route::post('/_update', [CategoryController::class, 'update'])->name('category');
      Route::post('/_delete', [CategoryController::class, 'delete'])->name('category');
    });

    Route::prefix('product')->group(function () {
      Route::prefix('units')->group(function () {
        Route::get('/', [UnitController::class, 'index'])->name('product/unit');
        Route::get('/add', [UnitController::class, 'add'])->name('product/unit');
        Route::get('/edit/{id}', [UnitController::class, 'edit'])->name('product/unit');
        Route::post('/_store', [UnitController::class, 'store'])->name('product/unit');
        Route::post('/_update', [UnitController::class, 'update'])->name('product/unit');
        Route::post('/_delete', [UnitController::class, 'delete'])->name('product/unit');
      });

      Route::prefix('packages')->group(function () {
        Route::get('/', [PackageController::class, 'index'])->name('product/package');
        Route::get('/add', [PackageController::class, 'add'])->name('product/package');
        Route::get('/edit/{id}', [PackageController::class, 'edit'])->name('product/package');
        Route::post('/_store', [PackageController::class, 'store'])->name('product/package');
        Route::post('/_update', [PackageController::class, 'update'])->name('product/package');
        Route::post('/_delete', [PackageController::class, 'delete'])->name('product/package');
      });
    });

    Route::prefix('products')->name('product')
    ->controller(ProductController::class)->group(function () {
      Route::get('/', 'index');
      Route::get('/find/{id}', 'find');
      /*
      Route::get('/edit/{id}', 'edit');
      Route::post('/_store', 'store');
      Route::post('/_update', 'update');
      Route::post('/_delete', 'delete');
      */
    });

    Route::prefix('venture/subscription')->name('venture/subscription')
    ->controller(VentureController::class)->group(function () {
      Route::get('', 'subscription');
    });

    Route::prefix('ventures')->name('venture')
    ->controller(VentureController::class)->group(function () {
      Route::get('/', 'index');
      Route::get('/find/{id}', 'find');
      Route::post('/_verification', '_verification');
      Route::post('/_delete', 'delete');

      Route::get('/cooperation/{id}', 'cooperation');
      Route::post('/_cooperation', '_cooperation');

      Route::get('/wallet/{id}', 'wallet');
      Route::post('/_wallet', '_wallet');

      Route::get('/saldo/{id}', 'saldo');
      Route::post('/_saldo', '_saldo');
      /*
      Route::get('/add', 'add');
      Route::get('/edit/{id}', 'edit');
      Route::post('/_store', 'store');
      Route::post('/_update', 'update');
      */
    });

    Route::prefix('revenue/subscription')->name('revenue/subscription')
      ->controller(WithdrawSubscribeController::class)->group(function () {
      Route::get('/', 'index');
      Route::post('store', 'store');
      Route::post('otp', 'otp');
    });


    Route::prefix('revenue')->controller(RevenueController::class)->group(function () {
      Route::get('/', 'index');
      Route::post('store', 'store');

      Route::prefix('deposited')->name('revenue/deposited')->group(function () {
        Route::get('/', 'deposited');
        Route::post('store', 'storeUser');
      });

      Route::prefix('cost')->name('revenue/cost')->group(function () {
        Route::get('/', 'cost');
        Route::post('store', 'storeUser');
      });

      Route::prefix('profit')->name('revenue/profit')->group(function () {
        Route::get('/', 'profit');
        Route::post('store', 'storeUser');
      });
    });

    Route::prefix('top-up')->name('top-up')
    ->controller(TopUpController::class)->group(function () {
      Route::get('/', 'index');
      Route::get('proof-of-payment/{id}', 'proofOfPayment');
      Route::post('store', 'store');
      Route::post('_proof-of-payment', '_proofOfPayment');
    });

    Route::prefix('venture/withdraw')->name('venture/withdraw')
    ->controller(WithdrawController::class)->group(function () {
      Route::get('/', 'index');
      Route::get('/handle/{id}', 'handle');
      Route::post('/_handle', '_handle');
    });

    Route::prefix('professions')->name('profession')
    ->controller(ProfessionController::class)->group(function () {
      Route::get('/', 'index');
      Route::get('/add', 'add');
      Route::get('/edit/{id}', 'edit');
      Route::post('/_store', 'store');
      Route::post('/_update', 'update');
      Route::post('/_delete', 'delete');
    });

    Route::prefix('payment-method')->name('payment-method')
    ->controller(PaymentMethodController::class)->group(function () {
      Route::get('/', 'index');
      Route::get('/add', 'add');
      Route::get('/edit/{id}', 'edit');
      Route::post('/_update', 'update');
      Route::post('/_delete', 'delete');
    });

    Route::prefix('payment-method-type')->name('payment-method-type')
    ->controller(PaymentMethodTypeController::class)->group(function () {
      Route::get('/', 'index');
      Route::get('/add', 'add');
      Route::get('/edit/{id}', 'edit');
      Route::post('/_update', 'update');
      Route::post('/_delete', 'delete');
    });

    Route::prefix('branchs')->name('branch')
    ->controller(BranchController::class)->group(function () {
      Route::get('/', 'index');
      Route::get('/add', 'add');
      Route::get('/edit/{id}', 'edit');
      Route::post('/_store', 'store');
      Route::post('/_update', 'update');
      Route::post('/_delete', 'delete');
    });

    Route::prefix('vendor')->name('vendor')
    ->controller(VendorController::class)->group(function () {
      Route::get('/', 'index');
      Route::get('/find/{id}', 'find');
    });

    Route::prefix('po')->name('po')
    ->controller(PurchaseOrderController::class)->group(function () {
      Route::get('/', 'index');
      Route::get('/find/{id}', 'find');
    });

    Route::prefix('ar')->name('ar')
    ->controller(ArController::class)->group(function () {
      Route::get('/', 'index');
    });

    Route::prefix('opex/pengeluaran')->name('opex/pengeluaran')
    ->controller(OpexPengeluaran::class)->group(function () {
      Route::get('/', 'index');
      Route::get('/find/{id}', 'find');
    });

    Route::prefix('customer')->name('customer')
    ->controller(CustomerController::class)->group(function () {
      Route::get('/', 'index');
      Route::get('/find/{id}', 'find');
    });

    Route::prefix('shopping')->name('shopping')
    ->controller(ShoppingController::class)->group(function () {
      Route::get('/', 'index');
      Route::get('/find/{id}', 'find');
    });

    Route::prefix('subscriptions')->name('subscriptions')
    ->controller(SubscriptionController::class)->group(function () {
      Route::get('/', 'index');
      Route::get('/add', 'add');
      Route::get('/edit/{id}', 'edit');
      Route::post('/_store', 'store');
      Route::post('/_update', 'update');
      Route::post('/_delete', 'delete');
    });

  });
});